<?php

namespace Vlabs\MediaBundle\EventSubscriber;

use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Vlabs\MediaBundle\Manager\MediaManagerInterface;
use Vlabs\MediaBundle\MediaInterface;

class MediaResizeSubscriber implements EventSubscriber
{
    protected array $config;
    protected MediaManagerInterface $mediaManager;

    public function __construct(array $config, MediaManagerInterface $mediaManager)
    {
        $this->config       = $config;
        $this->mediaManager = $mediaManager;
    }

    public function getSubscribedEvents()
    {
        return [
            'postPersist',
            'postUpdate',
        ];
    }

    public function postPersist(LifecycleEventArgs $eventArgs): void
    {
        $this->onChange($eventArgs);
    }

    public function postUpdate(LifecycleEventArgs $eventArgs): void
    {
        $this->onChange($eventArgs);
    }

    private function onChange(LifecycleEventArgs $eventArgs): void
    {
        if (!$eventArgs->getObject() instanceof MediaInterface) {
            return;
        }

        /** @var MediaInterface $media */
        $media = $eventArgs->getObject();

        if (!isset($this->config['resize'][$media->getKey()])) {
            return;
        }

        if (null == $media->getFilename() || !in_array($media->getMimeType(), ['image/jpg', 'image/jpeg', 'image/png'])) {
            return;
        }

        $queuing = $this->mediaManager->getQueuing($media);

        if (method_exists($queuing, 'setObjectManager')) {
            $queuing->setObjectManager($eventArgs->getObjectManager());
        }

        $this->mediaManager->publishResize($media);
    }
}
