<?php

namespace Vlabs\MediaBundle\Command;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Exception\ORMException;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\TransactionRequiredException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Vlabs\MediaBundle\Entity\Media;
use Vlabs\MediaBundle\Manager\MediaManager;
use Vlabs\MediaBundle\Manager\MediaManagerInterface;

class ResizeMediaCommand extends Command
{
    protected static $defaultName = 'vlabs:media:resize';
    private EntityManagerInterface $entityManager;
    private MediaManagerInterface $mediaManager;

    public function __construct(EntityManager $entityManager, MediaManager $mediaManager)
    {
        $this->entityManager = $entityManager;
        $this->mediaManager  = $mediaManager;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setDescription('Resize image')
            ->addArgument('mediaId', InputArgument::REQUIRED)
            ->addArgument('thumb', InputArgument::REQUIRED);
    }

    /**
     * @throws OptimisticLockException
     * @throws TransactionRequiredException
     * @throws ORMException
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        /** @var Media $media */
        $media = $this->entityManager->find('VlabsMediaBundle:Media', $input->getArgument('mediaId'));

        $this->mediaManager->doResize($media, $input->getArgument('thumb'));

        return Command::SUCCESS;
    }
}
