<?php

namespace Vlabs\MediaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;
use Vlabs\MediaBundle\MediaInterface;
use Vlabs\MediaBundle\Repository\MediaRepository;

#[ORM\Entity(repositoryClass: MediaRepository::class)]
#[ORM\InheritanceType('SINGLE_TABLE')]
#[Vich\Uploadable]
abstract class Media implements MediaInterface
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    protected ?int $id = null;

    /**
     * @internal This is not a mapped field of entity metadata, just a simple property.
     *           If you need to override the mapping, you have to create a child class marked as Vich\Uploadable
     *           and re-define the mediaFile property with a new Vich\UploadableField configuration.
     */
    #[Vich\UploadableField(mapping: 'media', fileNameProperty: 'filename', mimeType: 'mimeType')]
    protected ?File $mediaFile = null;

    #[ORM\Column]
    private ?string $path = null;

    #[ORM\Column]
    private ?string $filename = null;

    #[ORM\Column]
    private ?string $mimeType = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    abstract public function getKey(): string;

    /**
     * {@inheritdoc}
     */
    public function getPath(): ?string
    {
        return $this->path;
    }

    /**
     * {@inheritdoc}
     */
    public function setPath($path): ?MediaInterface
    {
        $this->path = $path;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getFilename(): ?string
    {
        return $this->filename;
    }

    /**
     * {@inheritdoc}
     */
    public function setFilename(?string $filename): ?MediaInterface
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getMimeType(): ?string
    {
        return $this->mimeType;
    }

    /**
     * {@inheritdoc}
     */
    public function setMimeType(?string $mimeType): ?MediaInterface
    {
        $this->mimeType = $mimeType;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getMediaFile(): ?File
    {
        return $this->mediaFile;
    }

    /**
     * If manually uploading a file (i.e. not using Symfony Form) ensure an instance
     * of 'UploadedFile' is injected into this setter to trigger the  update. If this
     * bundle's configuration parameter 'inject_on_load' is set to 'true' this setter
     * must be able to accept an instance of 'File' as the bundle will inject one here
     * during Doctrine hydration.
     *
     * {@inheritdoc}
     */
    public function setMediaFile(?File $mediaFile = null): ?MediaInterface
    {
        $this->mediaFile = $mediaFile;

        return $this;
    }

    public function __clone()
    {
        $this->id = null;
        $this->setPath(null);
        $this->setMimeType(null);
        $this->setFilename(null);
    }
}
