<?php

namespace Vlabs\MediaBundle\Manager;

use Vich\UploaderBundle\Mapping\PropertyMapping;
use Vlabs\MediaBundle\MediaInterface;
use Vlabs\MediaBundle\Queuing\QueuingInterface;

interface MediaManagerInterface
{
    /**
     * Fill MediaEntity from objects infos
     */
    public function remapMedia(MediaInterface $media, PropertyMapping $mapping);

    /**
     * Create resize process for the wanted queuing system
     */
    public function publishResize(MediaInterface $media);

    /**
     * Trigger resize process
     */
    public function doResize(MediaInterface $media, $thumb);

    /**
     * Get the queuing system for the current media
     */
    public function getQueuing(MediaInterface $media): QueuingInterface;

    /**
     * Get a media URI from given config
     */
    public function getUri(MediaInterface $media, bool $absolute = false, ?string $thumb = null): string;

    /**
     * Check if a media exists and its thumbnails
     */
    public function hasMedia(MediaInterface $media, ?string $thumb = null): bool;

    /**
     * Delete a media and its thumbnails
     */
    public function deleteMedia(MediaInterface $media): void;
}
