<?php

namespace Vlabs\MediaBundle\Storage;

use League\Flysystem\FilesystemOperator;
use League\Flysystem\MountManager;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Vich\UploaderBundle\Storage\FlysystemStorage;

class Storage extends FlysystemStorage
{
    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    public function getFilesystemFromKey(string $key): FilesystemOperator
    {
        if ($this->registry instanceof MountManager) {
            return $this->registry;
        }

        return $this->registry->get($key);
    }
}
