<?php

namespace Vlabs\MediaBundle\Twig\Extension;

use Symfony\Component\Asset\Packages;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Vlabs\MediaBundle\Manager\MediaManagerInterface;
use Vlabs\MediaBundle\MediaInterface;

class MediaExtension extends AbstractExtension
{
    private MediaManagerInterface $mediaManager;
    private Packages $packages;

    public function __construct(MediaManagerInterface $manager, Packages $packages)
    {
        $this->mediaManager = $manager;
        $this->packages     = $packages;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('vlabs_media', [$this, 'media']),
        ];
    }

    public function media(MediaInterface $media, array $options = []): string
    {
        $absolute = $options['absolute'] ?? false;
        $thumb    = $options['thumb'] ?? null;

        // @dev: We do not check for media existence anymore because for some FS like AWS, it can add a lot of time to
        // have the information in the case of listing. We let the client handling 404 on media URI.
        return $this->mediaManager->getUri($media, $absolute, $thumb);
    }
}
