VlabsMediaBundle
================

Installation
------------

Add repository to compose.json
```json
{
    "repositories": [
        {
            "type": "composer",
            "url": "https://packages.v-labs.fr/"
        }
    ]
}
```

Type command

```
composer require vlabs/media-bundle
```

Update your .env with a VLABS_MEDIA_BASE_URL
```
#.env
###> vlabs/media-bundle ###
VLABS_MEDIA_BASE_URL=http://localhost
###< vlabs/media-bundle ###
```

Add the minimal configuration that makes the bundle work

```yaml
#config/packages/vlabs_media.yml
vlabs_media:
    default_base_url: '%env(VLABS_MEDIA_BASE_URL)%'
```

Add doctrine config for media class
```yaml
#config/packages/doctrine.yml
doctrine:
    orm:
        mappings:
            # if you use XML mapping
            VlabsMediaBundle:
                type: xml
                dir: "%kernel.project_dir%/vendor/vlabs/media-bundle/config/mapping"
                prefix: Vlabs\MediaBundle\Entity
                alias: VlabsMediaBundle
            # if you use PHP attribute mapping
            VlabsMediaBundle:
                dir: "%kernel.project_dir%/vendor/vlabs/media-bundle/src/Entity"
                prefix: Vlabs\MediaBundle\Entity
                alias: VlabsMediaBundle
```

Update form theme with templates for media field if needed

```yaml
#config/packages/twig.yml
twig:
    form_themes:
        - '@VlabsMedia/Form/theme.html.twig'
        # or '@VlabsMedia/Form/tailwind_theme.html.twig' for Tailwind CSS
```
You cant also copy/modify js and css file as needed and use them in yout templates :
- media-bundle/assets/media.css (don't needed if you use Tailwind CSS theme)
- media-bundle/assets/media.js (if you use Tailwind CSS, use tailwind_media.ts instead)
- media-bundle/assets/media_collection.js
```html
<script type="application/javascript" defer src="{{ asset('bundles/media.js') }}"></script>
<script type="application/javascript" defer src="{{ asset('bundles/media_collection.js') }}"></script>
<script type="text/javascript">
    window.addEventListener("DOMContentLoaded", (event) => {
        MediaType.init(document)
        MediaCollectionType.init(document)

        document.querySelector('.media-collection').addEventListener('addentry', function(e){
            MediaType.initMedia(e.detail.entryNode)
        })
    })
</script>
```


Usage
------------

Create an entity wich extends `Vlabs\MediaBundle\Entity\Media` and provide an unique value for `getKey()`. This value will be used to resolve which flysystem config to use.
In this example we use PHP attributes to configure Vich and Doctrine, but **you can use XML aswell, see behind for Vich XML config**.

```php
//App/Entity/ProfilePicture.pĥp

use Doctrine\ORM\Mapping as ORM;
use Vich\UploaderBundle\Mapping\Annotation as Vich;
use Vlabs\MediaBundle\Entity\Media;

#[ORM\Entity]
#[Vich\Uploadable]
class PublicMedia extends Media
{
    private const MAPPING = 'public';

    #[Vich\UploadableField(mapping: self::MAPPING, fileNameProperty: 'filename', mimeType: 'mimeType')]
    protected ?File $mediaFile = null;

    public function getKey(): string
    {
        return self::MAPPING;
    }
}
```

If you use a collection of media you should add index-by="id" on inverseSide

```xml
<!--config/mapping/Profile.orm.xml-->
<one-to-one
    field="profilePicture"
    target-entity="App\Entity\PublicMedia"
    orphan-removal="true"
>
    <cascade>
        <cascade-all/>
    </cascade>
</one-to-one>
<!--OR-->
<one-to-many
    field="profilePictures"
    target-entity="App\Entity\PublicMedia"
    mapped-by="profile"
    orphan-removal="true"
    index-by="id"
>
    <cascade>
        <cascade-all/>
    </cascade>
</one-to-many>
```

Create vichuploader mapping for your entity (**except if you use PHP attributes in your entity like previous example**)
```xml
<!--App/Entity/ProfilePicture.xml-->
<vich_uploader class="App\Entity\PublicMedia">
    <field
        mapping="public"
        name="mediaFile"
        filename_property="filename"
    />
</vich_uploader>
```

Create a flystem adapter and a mount point to create a folder for your upload, for example :

```yaml
#config/packages/oneup_flysystem.yaml
oneup_flysystem:
    adapters:
        public_adapter:
            local:
                directory: "%kernel.project_dir%/public/uploads"
                permissions:
                    file:
                        public: 0o644
                    dir:
                        public: 0o755
        private_adapter:
            local:
                location: "%kernel.project_dir%/private/files"
                permissions:
                    file:
                        private: 0o600
                    dir:
                        private: 0o700
    filesystems:
        public:
            adapter: public_adapter
            mount: public
            visibility: public
            directory_visibility: public
        private:
            adapter: private_adapter
            mount: private
            visibility: private
            directory_visibility: private
```

Modify vich_uploader config for loading vich mapping
```yaml
#config/packages/vich_uploader.yaml
vich_uploader:
    db_driver: orm
    storage: flysystem
    metadata:
        auto_detection: false
        directories:
            #Where your vich mapping files are located
            - { path: "%kernel.project_dir%/src/Entity", namespace_prefix: App\Entity } 
        # for PHP attribute configuration, just put "type: attribute" in metadata node
    mappings:
        public: # should be the same as the getKey() of your entity
            #prefix used in front of filename (in most case the same as adapter directory without /public)
            uri_prefix: /uploads 
            upload_destination: oneup_flysystem.public_filesystem # should be: oneup_flysystem.#{mount value of the filesystem to use}_filesystem
            namer: Vich\UploaderBundle\Naming\SmartUniqueNamer
        private:
            uri_prefix: /files
            upload_destination: oneup_flysystem.private_filesystem
            namer: Vich\UploaderBundle\Naming\SmartUniqueNamer
```
Modify vlabs_media config to handle your new entity
```yaml
#config/packages/vlabs_media.yaml
vlabs_media:
    resize:
        public:
            base_url: "%env(VLABS_MEDIA_BASE_URL)%"
            queuing: sync #Define wich queue you want to use (@see Vlabs\MediaBundle\Queuing)
            filesystem: public # should be the same as mount value of the flysystem to use
            thumbs: # configure multiple resizes as needed
                xs:
                    uri_prefix: /xs
                    size: { width: 150, height: 150 }
                    mode: inset
                sm:
                    uri_prefix: /sm
                    size: { width: 480, height: 480 }
                    mode: inset
                md:
                    uri_prefix: /md
                    size: { width: 1024, height: 768 }
                    mode: inset
```
