<?php

namespace Vlabs\MediaBundle;

use Symfony\Component\HttpFoundation\File\File;

interface MediaInterface
{
    public function setPath(?string $path): ?MediaInterface;

    public function getPath(): ?string;

    public function setFilename(?string $filename): ?MediaInterface;

    public function getFilename(): ?string;

    public function setMimeType(?string $mimeType): ?MediaInterface;

    public function getMimeType(): ?string;

    public function setMediaFile(File $mediaFile = null): ?MediaInterface;

    public function getMediaFile(): ?File;

    /**
     * Media key to handle custom actions
     */
    public function getKey(): string;
}
