<?php

namespace Vlabs\MediaBundle\Queuing;

use Doctrine\Persistence\ObjectManager;
use Vlabs\MediaBundle\MediaInterface;

class JmsJobQueuing implements QueuingInterface
{
    protected ObjectManager $om;

    public function setObjectManager(ObjectManager $om): void
    {
        $this->om = $om;
    }

    /**
     * {@inheritdoc}
     */
    public function enqueue(MediaInterface $media, $thumb): void
    {
        $job = new Job('vlabs:media_resize', [
            'mediaId' => $media->getId(),
            'thumb'   => $thumb,
        ], true, 'media', Job::PRIORITY_HIGH);
        $this->om->persist($job);
        $this->om->flush();
    }
}
