<?php

namespace Vlabs\MediaBundle\Queuing;

class QueuingChain
{
    /** @var QueuingInterface[] */
    private array $queuings = [];

    public function addQueuing(QueuingInterface $queuing, $alias): void
    {
        $this->queuings[$alias] = $queuing;
    }

    public function getQueuing($alias): ?QueuingInterface
    {
        if (array_key_exists($alias, $this->queuings)) {
            return $this->queuings[$alias];
        }

        return null;
    }
}
