export default function Media(element: HTMLElement) {
  const fileInput: HTMLInputElement = element.querySelector('input[type="file"]');

  const handleFileChange = (file) => {
    if (file) {
      const isImage = file.type.includes('image')
      let url       = URL.createObjectURL(file);

      if (isImage) {
        element.querySelector('img').src = url;
      } else {
        const filenameElement = element.querySelector('small');
        filenameElement.innerHTML = file.name;
        filenameElement.title = file.name;
      }

      element.dataset.fileUploaded = '1';

      element.dispatchEvent(new CustomEvent('addfile', {
        bubbles:true,
        detail:{
          file: file
        }
      }))
    } else {
      fileInput.value = null;

      element.dataset.fileUploaded = '0';

      element.dispatchEvent(new CustomEvent('removefile', {
        bubbles:true,
        detail:{
          file: file
        }
      }))
    }
  }

  let inputAddListener = e => {
    const files = e.target.files
    if (files && files.length) {
      handleFileChange(files[0])
    }
  }

  fileInput.addEventListener('change', inputAddListener)

  let removeBtnListener = e => {
    e.preventDefault();
    handleFileChange(null)
    const checkRemove = e.currentTarget.querySelector('input[type="checkbox"]')
    if (checkRemove) {
      checkRemove.checked = true;
    }
  }

  element.querySelector('[data-action="remove-media"]').addEventListener('click', removeBtnListener)
}