<?php

namespace Vlabs\MediaBundle\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Vich\UploaderBundle\Event\Event;
use Vich\UploaderBundle\Event\Events;
use Vlabs\MediaBundle\Manager\MediaManagerInterface;
use Vlabs\MediaBundle\MediaInterface;

class MediaEventSubscriber implements EventSubscriberInterface
{
    protected MediaManagerInterface $mediaManager;

    public function __construct(MediaManagerInterface $mediaManager)
    {
        $this->mediaManager = $mediaManager;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            Events::PRE_UPLOAD => 'preUpload',
            Events::PRE_REMOVE => 'preRemove',
        ];
    }

    /**
     * Handle Media Transformation
     */
    public function preUpload(Event $event): void
    {
        $object = $event->getObject();
        if ($object instanceof MediaInterface) {
            $this->mediaManager->remapMedia($object, $event->getMapping());
        }
    }

    /**
     * Handle Media Deletion
     */
    public function preRemove(Event $event): void
    {
        $object = $event->getObject();
        if ($object instanceof MediaInterface) {
            $this->mediaManager->deleteMedia($object);
        }
    }
}
